<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDealsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('deals', function (Blueprint $table) {
            $table->id(); // المعرف الفريد للصفقة
            $table->string('title'); // عنوان الصفقة
            $table->text('description'); // وصف الصفقة
            $table->string('category'); // فئة الصفقة (تصميم، برمجة، إلخ)
            $table->decimal('price', 10, 2); // سعر الصفقة
            $table->string('duration'); // مدة الصفقة (ساعة، يوم، أسبوع)
            $table->string('status')->default('قيد المراجعة'); // حالة الصفقة
            $table->unsignedBigInteger('seller_id'); // مقدم الخدمة (مرتبط بجدول users)
            $table->unsignedBigInteger('buyer_id'); // طالب الخدمة (مرتبط بجدول users)
            $table->timestamps(); // تاريخ الإنشاء والتحديث

            // إضافة مفاتيح خارجية
            $table->foreign('seller_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('buyer_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('deals');
    }
}