<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\Report;

class ViewServiceProvider extends ServiceProvider
{
    public function boot()
    {
        View::composer('*', function ($view) {
            $pending_reports_count = Report::where('status', 'pending')->count();
            $under_review_reports_count = Report::where('status', 'under_review')->count();
            $resolved_reports_count = Report::where('status', 'resolved')->count();
            $dismissed_reports_count = Report::where('status', 'dismissed')->count();
            $total_reports_count = Report::count();

            $view->with([
                'pending_reports_count' => $pending_reports_count,
                'under_review_reports_count' => $under_review_reports_count,
                'resolved_reports_count' => $resolved_reports_count,
                'dismissed_reports_count' => $dismissed_reports_count,
                'total_reports_count' => $total_reports_count,
            ]);
        });
    }

    public function register()
    {
        //
    }
}
