<?php

namespace App\Providers;

use Illuminate\Support\Facades\View; // أضف هذا الاستيراد
use Illuminate\Support\ServiceProvider;
use App\Models\WalletTransaction;
use App\Models\WithdrawalRequest;

class ViewComposerServiceProvider extends ServiceProvider
{
    public function boot()
    {
        View::composer('admin.layouts.sidebar', function ($view) {
            $view->with([
                'pendingTransactionsCount' => WalletTransaction::where('status', 'pending')->count(),
                'pendingWithdrawalsCount' => WithdrawalRequest::where('status', 'pending')->count()
            ]);
        });
    }
}