<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserBan extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'banned_until',
        'reason',
        'admin_id',
        'is_active',
        'ban_message',
        'ban_image_url',
    ];

    protected $casts = [
        'banned_until' => 'datetime',
        'is_active' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function admin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }

    public function isActive()
    {
        return $this->is_active && ($this->banned_until === null || $this->banned_until->isFuture());
    }
}


