<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ScreenCaptureViolation extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'violation_type',
        'violation_timestamp',
        'metadata',
    ];

    protected $casts = [
        'metadata' => 'array',
        'violation_timestamp' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}


