<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'ad_id',
        'title',
        'description',
        'category',
        'price',
        'status',
    ];

    /**
     * 🔹 العلاقة مع المستخدم
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * 🔹 العلاقة مع الإعلان
     */
    public function ad()
    {
        return $this->belongsTo(Ad::class, 'ad_id');
    }
}
