<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Dispute extends Model
{
    use HasFactory;

    protected $fillable = [
        'deal_message_id',
        'reporter_id',
        'admin_id',
        'reason',
        'status',
        'resolved_at',
    ];

    protected $dates = ['resolved_at'];

    // العلاقة مع الرسالة (deals_messages)
    public function dealMessage() // ← تعديل الاسم ليكون متوافق مع الكود
    {
        return $this->belongsTo(DealsMessages::class, 'deal_message_id');
    }

    public function reporter()
    {
        return $this->belongsTo(User::class, 'reporter_id');
    }

    public function admin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }

    public function scopeActive($query)
    {
        return $query->whereIn('status', ['pending', 'in_progress']);
    }

    public static function statuses()
    {
        return [
            'pending' => 'قيد الانتظار',
            'in_progress' => 'قيد المعالجة',
            'resolved' => 'تم الحل'
        ];
    }
}