<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DealsMessages extends Model
{
    use HasFactory;

    protected $fillable = [
        'thread_id',
        'sender_id',
        'receiver_id',
        'message',
        'read',
        'has_dispute'
    ];

    protected $casts = [
        'read' => 'boolean',
    ];

    // علاقات
    public function sender()
    {
        return $this->belongsTo(User::class, 'sender_id');
    }

    public function receiver()
    {
        return $this->belongsTo(User::class, 'receiver_id');
    }

    // العلاقة مع النزاع
    public function dispute()
    {
        return $this->hasOne(Dispute::class, 'deal_message_id');
    }
public function messages()
{
    return $this->hasMany(Message::class);
}
    // Scope اختياري
    public function scopeWithDispute($query)
    {
        return $query->where('has_dispute', true);
    }
}