<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Conversation extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_one_id',
        'user_two_id',
        'last_message_id',
    ];

    /**
     * Get the first user in the conversation.
     */
    public function userOne()
    {
        return $this->belongsTo(User::class, 'user_one_id');
    }

    /**
     * Get the second user in the conversation.
     */
    public function userTwo()
    {
        return $this->belongsTo(User::class, 'user_two_id');
    }

    /**
     * Get all chat messages for the conversation.
     */
    public function chatMessages()
    {
        return $this->hasMany(ChatMessage::class);
    }

    /**
     * Get the last chat message of the conversation.
     */
    public function lastMessage()
    {
        return $this->belongsTo(ChatMessage::class, 'last_message_id');
    }

    /**
     * Get the other user in the conversation.
     */
    public function getOtherUserAttribute()
    {
        return $this->user_one_id === auth()->id() ? $this->userTwo : $this->userOne;
    }

    /**
     * Check if the conversation has unread messages for the current user.
     */
    public function hasUnreadMessages()
    {
        if (!$this->lastMessage) {
            return false;
        }

        // If the last message was sent by the current user, it's considered read by them
        if ($this->lastMessage->sender_id === auth()->id()) {
            return false;
        }

        // Check if there are any unread messages for the current user
        return $this->chatMessages()
                    ->where('read', false)
                    ->where('sender_id', '!=', auth()->id())
                    ->exists();
    }
}

