<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ClosedConversation extends Model
{
    use HasFactory;

    protected $fillable = [
        'conversation_id',
        'closed_by',
        'closure_reason',
        'report_id'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * العلاقة مع الإداري الذي أغلق المحادثة
     */
    public function closedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'closed_by');
    }

    /**
     * العلاقة مع الإبلاغ المرتبط
     */
    public function report(): BelongsTo
    {
        return $this->belongsTo(Report::class);
    }

    /**
     * التحقق من إغلاق محادثة معينة
     */
    public static function isConversationClosed($conversationId)
    {
        return self::where('conversation_id', $conversationId)->exists();
    }

    /**
     * الحصول على سبب إغلاق المحادثة
     */
    public static function getClosureReason($conversationId)
    {
        $closedConversation = self::where('conversation_id', $conversationId)->first();
        return $closedConversation ? $closedConversation->closure_reason : null;
    }
}

