<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ad extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'title',
        'description',
        'price',
    ];

    // 🔹 علاقة الإعلان مع الطلبات (Order)
    public function orders()
    {
        return $this->hasMany(Order::class, 'ad_id');
    }
    public function owner()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}