<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ScreenCaptureViolation;
use App\Models\UserBan;
use Illuminate\Support\Facades\Auth;

class BanController extends Controller
{
   public function reportViolation(Request $request)
{
    $user = Auth::user();

    if (!$user) {
        return response()->json(["message" => "Unauthenticated."], 401);
    }

    // تسجيل المخالفة
    ScreenCaptureViolation::create([
        "user_id" => $user->id,
        "violation_type" => "screen_capture",
        "metadata" => [
            "device_info" => $request->header("User-Agent"),
            "ip_address" => $request->ip(),
            "course_id" => $request->input("course_id"),
            "lesson_id" => $request->input("lesson_id"),
        ],
    ]);

    // حساب عدد المخالفات
    $violationCount = ScreenCaptureViolation::where("user_id", $user->id)->count();

    // تطبيق الحظر عند الوصول إلى 3 مخالفات أو أكثر
    if ($violationCount >= 3) {
        $banDuration = now()->addDays(7); // حظر لمدة 7 أيام

        // تحديث الحظر إذا كان موجودًا، أو إنشاؤه إذا لم يكن
        UserBan::updateOrCreate(
            ['user_id' => $user->id],
            [
                'banned_until' => $banDuration,
                'reason' => 'انتهاكات التقاط الشاشة المتعددة.',
                'is_active' => true,
                'ban_message' => 'لقد انتهكت حقوق الطبع والنشر عدة مرات. تم حظرك مؤقتاً. يرجى الانتظار حتى انتهاء مدة الحظر.',
                'ban_image_url' => 'https://license.zeinplatform.com/banned.png',
            ]
        );

        return response()->json([
            "message" => "User banned due to multiple violations.",
            "ban_details" => $user->fresh()->activeBan,
        ], 200);
    }

    return response()->json([
        "message" => "Violation reported.",
        "violation_count" => $violationCount,
    ], 200);
}

    public function checkBanStatus(Request $request)
    {
        $user = Auth::user();

        if (!$user) {
            return response()->json(["message" => "Unauthenticated."], 401);
        }

        $activeBan = $user->activeBan;

        if ($activeBan && $activeBan->isActive()) {
            return response()->json(["is_banned" => true, "ban_details" => $activeBan], 200);
        } else {
            // Deactivate expired bans
            if ($activeBan && !$activeBan->isActive()) {
                $activeBan->update(["is_active" => false]);
            }
            return response()->json(["is_banned" => false], 200);
        }
    }
}



